/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.InterfaceImpl;
import com.ibm.hwmca.fw.managed.MOCapabilities;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.TowerProperties;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.TaskDefinitionXML;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Tower
extends HwmcaObject
implements TowerProperties,
InterfaceImpl {
    protected static String TOWER_PLUGINS_PATH;
    private static final String PLUGINS_PATH = "plugins";
    private static final FrameworkClassLogInfo logInfo;
    private static final String TRACE_MASKT = "XFRMTWRT";
    private static final String TRACE_MASKF = "XFRMTWRF";
    private static final String TRACE_MASKD = "XFRMTWRD";
    private static Map classMap;
    private static Object classMapMonitor;
    private String xmlFile;

    protected Tower(String name) {
        ObjectId id = new ObjectId(this);
        if (name != null) {
            id.setKeyProperty("Name", name);
        }
        this.setObjectId(id);
    }

    protected Tower(PersistentData data, String persistKey) {
        super(data, persistKey);
    }

    public String getName() {
        String result = (String)this.getObjectId().getKeyProperty("Name");
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void setXMLFile(String fileName) {
        this.xmlFile = fileName;
    }

    public String getXMLFile() {
        return this.xmlFile;
    }

    public abstract void startTower() throws HException;

    public abstract void stopTower() throws HException;

    public List getUIBooks() {
        ArrayList books = new ArrayList();
        try {
            String fileName = this.getBooksXMLFileName();
            if (fileName != null) {
                TaskDefinitionXML.getUIBooks(fileName, books);
            }
        }
        catch (HException exc) {
            FrameworkLog log = new FrameworkLog(logInfo, 2462, exc);
            log.log();
        }
        return books;
    }

    protected String getBooksXMLFileName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInterfaceImpl(Class interfaceId) {
        Trace.trace(TRACE_MASKT, "-> getInterfaceImpl(interfaceId=" + interfaceId + ")");
        Object result = null;
        if (interfaceId.isAssignableFrom(this.getClass())) {
            result = this;
        } else {
            Object object = classMapMonitor;
            synchronized (object) {
                Map utilities = Tower.getClassMap();
                for (Class<?> classId = this.getClass(); classId != null && result == null; classId = classId.getSuperclass()) {
                    Map interfaces = (Map)utilities.get(classId.getName());
                    if (interfaces == null || !((result = interfaces.get(interfaceId.getName())) instanceof String)) continue;
                    Exception exception = null;
                    if (((String)result).endsWith("^")) {
                        try {
                            result = ((String)result).substring(0, ((String)result).length() - 1);
                            result = Class.forName((String)result).newInstance();
                            interfaces.put(interfaceId.getName(), result);
                            Trace.trace(TRACE_MASKD, "Lazy instantiated: " + interfaceId.getName());
                        }
                        catch (Exception exc) {
                            exception = exc;
                        }
                    } else {
                        try {
                            Class<?> implClass = Class.forName((String)result);
                            try {
                                Constructor<?> constructor = implClass.getConstructor(classId);
                                result = constructor.newInstance(this);
                            }
                            catch (NoSuchMethodException e) {
                                result = implClass.newInstance();
                            }
                        }
                        catch (ClassNotFoundException exc) {
                            exception = exc;
                        }
                        catch (InstantiationException exc) {
                            exception = exc;
                        }
                        catch (IllegalAccessException exc) {
                            exception = exc;
                        }
                        catch (InvocationTargetException exc) {
                            exception = exc;
                        }
                    }
                    if (exception == null) continue;
                    FrameworkLog log = new FrameworkLog(logInfo, 2453, exception);
                    log.add("Could not instantiate class: " + result);
                    log.log();
                    result = null;
                    break;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- getInterfaceImpl(returns " + (result == null ? "null" : result.getClass().getName()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addClassInterfaceImpl(Class classId, Class interfaceId, Object implementation) {
        Trace.trace(TRACE_MASKT, "<> addClassInterfaceImpl(classId=" + classId + ",interfaceId=" + interfaceId + ")");
        Object object = classMapMonitor;
        synchronized (object) {
            HashMap<String, Object> interfaces = (HashMap<String, Object>)Tower.getClassMap().get(classId.getName());
            if (interfaces == null) {
                interfaces = new HashMap<String, Object>();
                classMap.put(classId.getName(), interfaces);
            }
            interfaces.put(interfaceId.getName(), implementation);
        }
    }

    private static Map getClassMap() {
        if (classMap == null) {
            classMap = new HashMap();
        }
        return classMap;
    }

    public MOCapabilities[] getMOCapabilities() {
        Trace.trace(TRACE_MASKT, "<> Tower.getMOCapabilities()");
        return new MOCapabilities[0];
    }

    static {
        logInfo = new FrameworkClassLogInfo(85, "Tower");
        classMapMonitor = new Object();
        try {
            TOWER_PLUGINS_PATH = BaseFileControl.getFilePath(PLUGINS_PATH) + "tower/";
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Error finding tower plugins path");
            Trace.trace(TRACE_MASKF, e);
        }
    }
}

